;*****************************************************************************
;  FILENAME: Synth.inc
;  Version: 1.1
;  (c) Ilya Mamontov 2008-2009, 2025
;
;        
;
;*****************************************************************************
CMAX:		equ	5	;    (       )

;-----------------------------------------------
;  Macros Definitions
;-----------------------------------------------



;---------------------------------------------------------------------------------------------------------------------------------------------
;    
;    512 
;---------------------------------------------------------------------------------------------------------------------------------------------
macro synth_keyscan	;    
	;  [controls+0]  [controls+1]
	mov A,reg[PRT2DR]
	and A,0xF0			;  

	cmp [mask],8
	jnz .m1
		mov [keys+1],A	;,     D3
	.m1:	
	cmp [mask],4
	jnz .m2
		rrc A			;,     D2
		asr A
		asr A
		asr A
		or [keys+1],A
	.m2:	
	cmp [mask],2
	jnz .m3
		mov [keys+0],A	;,     D1
	.m3:	
	cmp [mask],1
	jnz .m4
		rrc A			;,     D0
		asr A
		asr A
		asr A
		or [keys+0],A
	.m4:
	; 	
	asr [mask]
	jnz .next_mask
		;  4  
		mov [mask],0x08	; 
			mov A,[keys+0]		;   ?
			cmp A,[keys+2]
		jnz .reset_cnt			;,   
			mov A,[keys+1]
			cmp A,[keys+3]
		jnz .reset_cnt			;,   
				inc [keycnt]		;   ( )
				sbb [keycnt],0		;255 -  
				cmp [keycnt],CMAX+1	;  -  , .. "  " (  )
				jnz .next_mask		;    
					; 
					mov A,[mask]
					mov reg[PRT2DR],A	;   
					synth_keyprocess	;   (  )
										;   [keys+1] ( )     [keys+1] (.), [keys+0] ( )
					jmp .next_mask
		.reset_cnt:			
		mov [keycnt],0			;  
		mov [keys+2],[keys+0]	;   ""	
		mov [keys+3],[keys+1]	
	.next_mask:
	mov A,[mask]
	mov reg[PRT2DR],A	;   
endm


;---------------------------------------------------------------------------------------------------------------------------------------------
;     (   synth_keyscan,    , . )
;  : [keys+0]  [keys+1]    :
;	[keys+0] . -   0, 1 ... 9 
;	[keys+0] . -   0, 10 ... 90 
;	[keys+1] . -   0, 100  ... 900 
;	[keys+1] . -   
;---------------------------------------------------------------------------------------------------------------------------------------------
macro synth_keyprocess
	;      -    , ..       "Set",  "<-"    "->"
	mov A,[keyOld]		;    , ..   
	mov [keyOld],[keys+1];      (     )
		; A -   	

	tst [keys+1],0x10	;   "Set"
	jz .n0
		;---  "   "
		jmp set_track	;   main.asm (  ) -  

.n0:
	tst [keys+1],0x20	;    "<-"
	jz .n1
		;---  "   "
		dec [altName+2] ;      1
		cmp [altName+2],'0'
		jnc .next_char
			mov [altName+2],'9'
			dec [altName+1]
			cmp [altName+1],'0'
			jnc .next_char
				mov [altName+1],'9'
				dec [altName+0]
				cmp [altName+0],'0'
				jnc .next_char
					mov [altName+0],'9'
		.next_char:
		jmp start	;   main.asm (  ) -  
.n1:
	tst [keys+1],0x40	;    "->"
	jz .n2
		;---  "   "
	inc [altName+2]	;      1
		cmp [altName+2],'9'+1
		jc .next_char1
			mov [altName+2],'0'
			inc [altName+1]
			cmp [altName+1],'9'+1
			jc .next_char1
				mov [altName+1],'0'
				inc [altName+0]
				cmp [altName+0],'9'+1
				jc .next_char1
					mov [altName+0],'0'
		.next_char1:
		jmp start	;	;   main.asm (  ) -  
.n2:
	tst [keys+1],0x80	;   "Play"
	jz .n3
		;---  ""
		or [mode],1			;   
		jmp .n5				;    ,   

.n3: ;  "Play"
	tst [mode],1		;   ? (    "")
	jz .n4				; (  )
		;---   ""
		call synth_notes_off; -     
		and [mode],~1		;   
		jmp .n5				;    ,   
	

.n4: ;     - ,     
	; A      	
	xor A,[keys+1]		;      ?
	and A, 0xF0			;    ,     
	jnz .n5				;    - 	
		;     -     (     )
		;tst [mode],1		;     Play   
		;jnz .n5
		cmp [tickcnt],100	;     ([tickcnt]<100)    
		jc .n5
			;        
			jmp set_track	;   main.asm (  ) -  	

.n5: ;

endm
